%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate6_Main.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This runs the project for 6 sensor colors
%--------------------------------------------------------------------------
close all; clear all; clc;
warning('OFF');

Recover = false;         % Used if the simulation has been interrupted and
                         % we need to pick up where we left off
if(Recover)
    load Simulate6Data.mat;
    load Simulate6_sensorIndex.mat;
    load SavedData6;
    load SensorData6.mat;
else
    % Generate all the sensor data that we will be using in SensorData5.mat
    GenSensorData6; clear all; 
    load SensorData6.mat
   
    NumRows = size(sensorSettings,1);       % Number of different sensors that we're running
    colorMetrics = zeros(NumRows,1);        % Initialize vector to save color metrics            
    noiseMetrics = zeros(NumRows,1);        % Initialize vector to save noise metrics
    frequencyMetrics = zeros(NumRows,1);    % Initialize vector to save frequency metrics

    sensorIndex = 1;
    analysisIndex = 1;
    save('SavedData6.mat','colorMetrics','noiseMetrics','frequencyMetrics','sensorIndex','analysisIndex');
end


% Loop through all the sensors
Simulate6_Sub;


% Put the results into a matrix that we can save
%--------------------------------------------------------
ResultNames6 = sensorSettings_Names;
Results6 = sensorSettings;

Results6 = [Results6 colorMetrics frequencyMetrics noiseMetrics]; 
ResultNames6 = {ResultNames6{:},'deltaE','MTF50','yNoise'};


% Display the results
disp(ResultNames6);
disp(Results6);

% Save the final results
save('Results_6.mat', 'ResultNames6', 'Results6');

% Plot the final results

colors = ['r', 'g', 'b', 'y', 'c', 'm', 'k'];
figure(1);
plot(frequencyMetrics, colorMetrics, 'bo');
xlabel('MTF-50');
ylabel('Average \Delta E');
title('\bfColor Accuracy vs Frequency Accuracy, 6 colors');
grid on;
axis([0 max(1.2*frequencyMetrics) 0 max(1.2*colorMetrics)]);

saveas(gcf, ['./Images/Results_6.png']);






